<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->index('created_at', 'invoices_created_at_idx');
            $table->index(['status', 'created_at'], 'invoices_status_created_at_idx');
        });

        Schema::table('ledger_entries', function (Blueprint $table) {
            $table->index(['account_id', 'created_at'], 'ledger_entries_account_created_at_idx');
            $table->index('created_at', 'ledger_entries_created_at_idx');
        });
    }

    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropIndex('invoices_created_at_idx');
            $table->dropIndex('invoices_status_created_at_idx');
        });

        Schema::table('ledger_entries', function (Blueprint $table) {
            $table->dropIndex('ledger_entries_account_created_at_idx');
            $table->dropIndex('ledger_entries_created_at_idx');
        });
    }
};
