<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('payments', function ($table) {
  $table->id();
  $table->foreignId('invoice_id')->nullable()->constrained()->nullOnDelete();
  $table->decimal('amount', 14, 2);
  $table->enum('method', ['cash','transfer','pos']);
  $table->foreignId('account_id')->constrained('accounts')->cascadeOnDelete(); // cash/bank
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
