<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('expenses', function ($table) {
  $table->id();
  $table->string('category');
  $table->decimal('amount', 14, 2);
  $table->foreignId('expense_account_id')->constrained('accounts')->cascadeOnDelete();
  $table->foreignId('payment_account_id')->constrained('accounts')->cascadeOnDelete(); // cash/bank
  $table->string('note')->nullable();
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
