<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('stock_movements', function ($table) {
  $table->id();
  $table->foreignId('product_id')->constrained()->cascadeOnDelete();
  $table->enum('type', ['sale','restock','adjustment','return','void_sale']);
  $table->integer('qty_change'); // negative for sale
  $table->string('reference_type')->nullable(); // invoice
  $table->unsignedBigInteger('reference_id')->nullable();
  $table->string('note')->nullable();
  $table->timestamps();

  $table->index(['reference_type','reference_id']);
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
