<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function ($table) {
            $table->id();
            $table->string('store_name');
            $table->string('address');
            $table->string('phone');
            $table->decimal('vat_percent', 5, 2)->default(7.50);
            $table->string('receipt_footer')->default('Thanks for your patronage');
            $table->timestamps();
            });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
