<?php

use Illuminate\Support\Facades\DB;

if (!function_exists('assertOpenPeriod')) {
  function assertOpenPeriod(DateTimeInterface $date): void
  {
    $month = date('Y-m-01', strtotime($date->format('Y-m-d')));

    $closed = DB::table('accounting_periods')
      ->where('month', $month)
      ->where('is_closed', true)
      ->exists();

    if ($closed) {
      abort(403, 'Accounting period closed');
    }
  }
}
