<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'sku',
        'barcode',
        'cost_price',
        'selling_price',
        'stock_qty',
        'low_stock_alert',
        'is_active',
        'category_id',
        'model',
        'size',
        'details',
    ];

    public function category()
    {
        return $this->belongsTo(ProductCategory::class, 'category_id');
    }

    public function items()
    {
        return $this->hasMany(ProductItem::class);
    }
}
