<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
  public function lookup(Request $request)
  {
    $code = $request->query('code');
    if (!$code) return response()->json(['message'=>'code is required'], 422);

    $p = Product::where('barcode',$code)->orWhere('sku',$code)->first();
    if (!$p) return response()->json(['message'=>'not_found'], 404);

    return response()->json($p);
  }

  // Offline sync: get changed products since timestamp
  public function sync(Request $request)
  {
    $since = $request->query('since');
    $q = Product::query();

    if ($since) {
      $q->where('updated_at', '>=', $since);
    }

    return response()->json([
      'server_time' => now()->toISOString(),
      'products' => $q->orderBy('updated_at','asc')->limit(5000)->get()
    ]);
  }
}
