<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Expense;
use App\Services\AccountingService;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
  public function store(Request $request, AccountingService $acct)
  {
    \assertOpenPeriod(now());

    $data = $request->validate([
      'category' => ['required','string'],
      'amount' => ['required','numeric','min:0.01'],
      'expense_account_id' => ['required','integer','exists:accounts,id'],
      'payment_account_id' => ['required','integer','exists:accounts,id'],
      'note' => ['nullable','string'],
    ]);

    $expense = Expense::create($data);

    $acct->postExpense(
      $expense->id,
      (float)$expense->amount,
      (int)$expense->expense_account_id,
      (int)$expense->payment_account_id,
      (string)($expense->note ?? $expense->category)
    );

    return response()->json($expense, 201);
  }
}
