<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Models\User;

class AuthController extends Controller
{
  public function login(Request $request)
  {
    $data = $request->validate([
      'email' => ['required','email'],
      'password' => ['required','string'],
      'device_name' => ['nullable','string'],
    ]);

    $user = User::where('email', $data['email'])->first();

    if (!$user || !password_verify($data['password'], $user->password)) {
      throw ValidationException::withMessages([
        'email' => ['Invalid login credentials'],
      ]);
    }

    $token = $user->createToken(
      $data['device_name'] ?? 'pos-app'
    )->plainTextToken;

    return response()->json([
      'token' => $token,
      'user' => [
        'id' => $user->id,
        'name' => $user->name,
        'email' => $user->email,
        'role' => $user->role ?? null,
      ],
    ]);
  }

  public function me(Request $request)
  {
    return response()->json([
      'id' => $request->user()->id,
      'name' => $request->user()->name,
      'email' => $request->user()->email,
      'role' => $request->user()->role ?? null,
    ]);
  }

  public function logout(Request $request)
  {
    $request->user()->currentAccessToken()->delete();

    return response()->json(['message' => 'Logged out']);
  }
}
